/*
 * Copyright 2013 Israel Martín Escalona <imartin@entel.upc.edu>
 * 
 * This file is part of Wipos.
 * 
 * Wipos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Wipos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Wipos.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include "pos_ioctls.h"
#include "positioning/globals.h"

#define BUFFER_SIZE 100
#define PRINT_MEASUREMENT(item) printf("%d %llu", item.source, item.dato)
#define PRINT_SEPARATOR printf("\n")
/* #define EXIT_SUCCESS (0); */

#define SAMPLES_TO_BYTES(n)	((unsigned long)(n) * sizeof(TYPE_OF_READ_ITEM))
#define BYTES_TO_SAMPLES(n)	((unsigned long)(n) / sizeof(TYPE_OF_READ_ITEM))

void print_measurements(TYPE_OF_READ_ITEM * buffer, unsigned long size)
{
    int i = 0;
    
    for (i = 0; i < size; i++)
    {
        PRINT_MEASUREMENT(buffer[i]);
        PRINT_SEPARATOR;
    }
	 
}

int main(int argc, char * argv[])
{
    int fid = -1;
    long nSamples = 0;
    unsigned long samples_read = 0;
    TYPE_OF_READ_ITEM buffer[BUFFER_SIZE];
    long  i = 0;

    
    // Checking enough parameters
    if (argc < 3) {
        printf("Usage: %s path_to_device number_of_samples [@active-node]\n", argv[0]);
        close(fid);
        return -EINVAL;
    }
    
    // Opening the device
    fid = open(argv[1], O_RDONLY );
    
    if (fid < 0) {
        perror( "Error opening device" );
        close(fid);
        return -ENOENT;
    }
    
    // Setting the active-node address if supplied
    if (argc > 3) {
        ioctl(fid, POS80211_IOC_SET_ACTIVE_NODE, argv[3]);
    }
    
    // Getting the number of samples to read
    nSamples = atol(argv[2]);
    
    if (nSamples == 0) {
        printf("The provided %s is not a valid amount of samples to read\n", argv[2]);
        close(fid);
        return -EINVAL;
    }
    
    // Reset the device
    ioctl(fid, POS80211_IOC_RESET);
    
    // Dumping the meassurements
    //printf("**Waiting for samples**\n");
    while(nSamples > 0) {
        i = read(fid, buffer, SAMPLES_TO_BYTES(nSamples >= BUFFER_SIZE ? BUFFER_SIZE : nSamples));
	
        if (i < 0)
        {
            printf("%ld samples read\n", i);
            perror("Error reading the samples");
            close(fid);
            return i;
        }
        
        samples_read = BYTES_TO_SAMPLES(i);
        nSamples -= samples_read;
        print_measurements(buffer, samples_read);
    }
    //printf("%ld samples read\n", i);
    
    close(fid);
    
    return EXIT_SUCCESS;
}
