/*
 * Copyright 2013 Israel Martín Escalona <imartin@entel.upc.edu>
 * 
 * This file is part of Wipos.
 * 
 * Wipos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Wipos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Wipos.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef VECTOR_H_
#define VECTOR_H_

#include <positioning/globals.h>
#include <linux/spinlock.h>
#include "k_container.h"

#define MAX_CONTAINER_NAME_SIZE 32
#define VECTOR_DEFAULT_SIZE 256



typedef struct
{
    spinlock_t		lock;      			/*  Lock  */
    unsigned long	rPos;      			/*  Reading position in the vector */
    unsigned long	wPos;				/*  Writting position in the vector */
    unsigned long	size;  				/*  Allocated size of the vector  */
    unsigned long	actualSize; 			/* Amount of data in the vector */
    char		name[MAX_CONTAINER_NAME_SIZE];	/*  Name of the vector */
    bool		isPointer;			/*  Indicates if the stored data are pointers or primitive variables */
} VectorProperties;

typedef struct
{
    VectorProperties 	properties;			/* properties of the vector */
    voidp * 		data;				/* data stored in the vector */
} Vector;

/*   Prototypes   */
Vector * vCreate(void);
void     vDelete(Vector * v);
void     vAddData(Vector * v, voidp item);
container_dato   vGetNext(Vector * v);
int      vIsEmpty(Vector * v);
int      vIsNotEmpty(Vector * v);
void     vLock(Vector * v);
void     vUnlock(Vector * v);
bool	 vResize(Vector * v, unsigned long size);
void     vSetName(Vector * v, char * name);
void     vClear(Vector * v);
void 	 vSetIsPointer(Vector * v, bool ip);
bool	 vIsPointer(Vector * v);
void 	 vReset(Vector * v);
unsigned long vGetActualSize(Vector * v);
unsigned long vGetMaximumSize(Vector * v);

#endif   /* VECTOR_H_ */
