/*
 * Copyright 2013 Israel Martín Escalona <imartin@entel.upc.edu>
 * 
 * This file is part of Wipos.
 * 
 * Wipos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Wipos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Wipos.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef TWO_WAY_TOA_H_
#define TWO_WAY_TOA_H_

#include <linux/types.h>
#include <positioning/globals.h>

void two_way_toa_init(void);
void two_way_toa_exit(void);
void clear_buffer_two_way_toa(void);
void set_gathering_buffer_two_way_toa(unsigned long samples);
void enable_gathering_two_way_toa(void);
void disable_gathering_two_way_toa(void);
read_return_struct get_next_rtt_two_way_toa(TYPE_OF_POSITIONING_DATA * buffer, unsigned long size);
unsigned long two_way_toa_data_in_buffer(void);
void two_way_toa_timestamp_tx(struct ieee80211_hdr *hdr, struct wiphy * wiphy);
void two_way_toa_timestamp_rx(TYPE_OF_POSITIONING_DATA last_rx_time, TYPE_OF_POSITIONING_DATA last_rx_clock, struct ieee80211_hw *hw, struct sk_buff *skb);
bool is_two_way_toa_enabled(void);

#endif
