/*
 * Copyright 2013 Israel Martín Escalona <imartin@entel.upc.edu>
 * 
 * This file is part of Wipos.
 * 
 * Wipos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Wipos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Wipos.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef QUEUE_H_
#define QUEUE_H_

#include <linux/list.h>
#include <linux/spinlock.h>
#include <positioning/globals.h>
#include "k_container.h"

#define MAX_QNAME_SIZE 32

typedef struct QueueItem
{
   struct list_head    list;      /* Linked List  */
   voidp               item;      /* Item of Data */
} QueueItem;

typedef struct
{
   struct list_head          list;      /*  List Head  */
   spinlock_t                lock;      /*  Lock  */
   unsigned long             size;      /*  Size of the queue  */
   unsigned long             max_size;  /*  Maximum size of the queue  */
   char                      name[MAX_QNAME_SIZE];      /*  Name of the queue  */
   bool			     isPointer; /* Flag for pointed items */
} Queue;

/*   Prototypes   */

Queue *  qCreate(void);
void     qDelete(Queue * q);
void     qAddData(Queue * q, voidp item);
container_dato qGetNext(Queue * q);
int      qIsEmpty(Queue * q);
int      qIsNotEmpty(Queue * q);
int      qLock(Queue * q);
void     qUnlock(Queue * q);
void     qResize(Queue * q, unsigned long new_max_size);
void     qSetName(Queue * q, char * name);
void     qClear(Queue * q);
void 	 qSetPointer(Queue * q, bool isPointer);
bool	 qIsPointer(Queue * q);
volatile unsigned long qGetActualSize(Queue * q);
volatile unsigned long qGetActualSize(Queue * q);

#endif   /* QUEUE_H_ */
