/*
 * Copyright 2013 Israel Martín Escalona <imartin@entel.upc.edu>
 * 
 * This file is part of Wipos.
 * 
 * Wipos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Wipos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Wipos.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef POSITIONING_UTILS_H
#define POSITIONING_UTILS_H

#include <linux/types.h>
#include <linux/kernel.h>

#define TIMESPEC_TO_NS(ts)	((TYPE_OF_POSITIONING_DATA)ts.tv_sec*1000000000 + (TYPE_OF_POSITIONING_DATA)ts.tv_nsec)
#define LOWERCASE(c)		((c) > 'A' ? (c) + 32 : (c))

int char_hex_to_int(char c);
void print_mac(u8 * mac);
void convert_mac_to_str(u8 * addr, char * str);
bool mac_addr_cmp(u8 * addr1, u8 * addr2);
void convert_str_to_mac(char * str, u8 * mac);
void byte_to_binary( int x, char * binaryStr);

#endif
