/*
 * Copyright 2013 Israel Martín Escalona <imartin@entel.upc.edu>
 * 
 * This file is part of Wipos.
 * 
 * Wipos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Wipos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Wipos.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include <linux/if_ether.h>	// For the macro ETH_ALEN
#include <linux/kernel.h>
#include "positioning_utils.h"

void convert_mac_to_str(u8 * addr, char * str)
{
    int i = 0;
    int offset = 0;
    
    offset = sprintf(str, "%02x", *addr);
    
    for (i = 1; i < ETH_ALEN; i++)
    {
	addr++;
	str += offset;
	offset = sprintf(str, ":%02x", *addr);
    }
}

bool mac_addr_cmp(u8 * addr1, u8 * addr2)
{
    int i = 0;
    
    while (i < ETH_ALEN && *addr1 == *addr2)
    {
	i++; addr1++; addr2++;
    }

    return (i == ETH_ALEN);
    
}

void print_mac(u8 * mac)
{
    int i = 0;
    
    printk("%02x", mac[0]);
    for (i = 1; i < ETH_ALEN; i++)
    {
	printk(":%02x", mac[i]);
    }
}

int char_hex_to_int(char c)
{
    if (c >= '0' && c <= '9')
	return (int)(c) - 48;
    else if (c >= 'a' && c <= 'f')
	return (int)(c) - 87;
    else if (c >= 'A' && c <= 'F')
	return (int)(c) - 55;
    else
	return -1;
}

void convert_str_to_mac(char * addr, u8 * mac)
{
    int i = 0;
    
    for (i = 0; i < ETH_ALEN; i++)
    {
	*mac = char_hex_to_int(*addr)*16;
	addr++;
	*mac += char_hex_to_int(*addr);
	addr += 2;	// To skip the separator
	mac++;
    }
}

void byte_to_binary( int x, char * binaryStr)
{
    int y;
    long long z;
    for (z=1LL<<(sizeof(int)*8-1),y=0; z>0; z>>=1,y++)
    {
        binaryStr[y] = ( ((x & z) == z) ? '1' : '0');
    }

    binaryStr[y] = 0;
}


