/*
 * Copyright 2013 Israel Martín Escalona <imartin@entel.upc.edu>
 * 
 * This file is part of Wipos.
 * 
 * Wipos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Wipos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Wipos.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef POSITIONING_MAIN_MACROS_H
    #define POSITIONING_MAIN_MACROS_H

    #include <positioning/globals.h>

    #ifdef _COMPUTE_TIME_IN_NS_ 
	#include "positioning_utils.h"
	#ifdef _COMPUTE_TIME_IN_CLOCKS_
	    #define POSITIONING_CAPTURE_RX_TIME(hw,skb)	/* TIMESTAP FOR POSITIONING */						\
							    cycles_t last_rx_clock = get_cycles();				\
							    TYPE_OF_POSITIONING_DATA last_rx_time = 0; 				\
							    struct timespec ts; 						\
																\
							    getnstimeofday(&ts);						\
							    last_rx_time = TIMESPEC_TO_NS(ts);					\
							    positioning_plugins_rx(last_rx_time, last_rx_clock, hw, skb);	\
							    /* ------------------------ */
	#else
	    #define POSITIONING_CAPTURE_RX_TIME(hw,skb)	/* TIMESTAP FOR POSITIONING */					\
							    TYPE_OF_POSITIONING_DATA last_rx_time = 0; 			\
							    struct timespec ts; 					\
															\
							    getnstimeofday(&ts);					\
							    last_rx_time = TIMESPEC_TO_NS(ts);				\
							    positioning_plugins_rx(last_rx_time, 0, hw, skb);		\
							    /* ------------------------ */
	#endif
    #else
	#ifdef _COMPUTE_TIME_IN_CLOCKS_
	    #define POSITIONING_CAPTURE_RX_TIME(hw,skb)	/* TIMESTAP FOR POSITIONING */					\
							    cycles_t last_rx_clock = get_cycles(); 			\
							    positioning_plugins_rx(0, last_rx_clock, hw, skb);		\
							    /* ------------------------ */
	#endif
    #endif			    
				
    #define POSITIONING_CAPTURE_TX_TIME(hdr,sdata)		/* TIMESTAP FOR POSITIONING */		\
								positioning_plugins_tx(hdr,sdata);	\
								/* ------------------------ */

    #define POSITIONING_CAPTURE_RETX_TIME(hdr,local)		/* TIMESTAP FOR POSITIONING */ 		\
								positioning_plugins_retx(hdr,local);	\
								/* ------------------------ */ 
					    

    #define POSITIONING_DECLARE_TX_FUNCTIONS	extern void positioning_plugins_tx(struct ieee80211_hdr * hdr, struct ieee80211_sub_if_data *sdata); 	\
						    extern void positioning_plugins_retx(struct ieee80211_hdr * hdr, struct ieee80211_local * local);
						    
    #define POSITIONING_DECLARE_RX_FUNCTIONS	extern void positioning_plugins_rx(TYPE_OF_POSITIONING_DATA last_rx_time, cycles_t last_rx_clock, struct ieee80211_hw *hw, struct sk_buff *skb);
    
    #define POSITIONING_DECLARE_REGISTERING_FUNCTIONS	extern void positioning_plugins_init(void);	\
							extern void positioning_plugins_exit(void);

#endif