/*
 * Copyright 2013 Israel Martín Escalona <imartin@entel.upc.edu>
 * 
 * This file is part of Wipos.
 * 
 * Wipos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Wipos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Wipos.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef POSITIONING_MAIN_H
#define POSITIONING_MAIN_H

#include <linux/types.h>
#include <linux/kernel.h>
#include <net/mac80211.h>
#include "ieee80211_i.h"
#include <positioning/globals.h>

					
inline void positioning_plugins_init(void);
inline void positioning_plugins_exit(void);

inline void positioning_plugins_rx(TYPE_OF_POSITIONING_DATA last_rx_time, cycles_t last_rx_clock, struct ieee80211_hw *hw, struct sk_buff *skb);
inline void positioning_plugins_tx(struct ieee80211_hdr * hdr, struct ieee80211_sub_if_data *sdata);
inline void positioning_plugins_retx(struct ieee80211_hdr * hdr, struct ieee80211_local * local);

#endif