/*
 * Copyright 2013 Israel Martín Escalona <imartin@entel.upc.edu>
 * 
 * This file is part of Wipos.
 * 
 * Wipos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Wipos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Wipos.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "positioning_main.h"
#include "two_way_toa.h"
#include "passive_tdoa_common.h"

// NOTHING TO DO. ALL IS INLINED!

inline void positioning_plugins_init(void)
{
    two_way_toa_init();
    common_passive_tdoa_init();
}


inline void positioning_plugins_exit(void)
{
    two_way_toa_exit();
    common_passive_tdoa_exit();
}

inline void positioning_plugins_rx(TYPE_OF_POSITIONING_DATA last_rx_time, cycles_t last_rx_clock, struct ieee80211_hw *hw, struct sk_buff *skb)
{
    if (is_two_way_toa_enabled())  /* Gathering 2-way TOA data enabled? */
    {
	two_way_toa_timestamp_rx(last_rx_time, last_rx_clock, hw, skb);
    }
    
    if (is_common_passive_tdoa_enabled())
    {
	common_passive_tdoa_timestamp_rx_data(last_rx_time, last_rx_clock, skb);
	common_passive_tdoa_timestamp_rx_ack(last_rx_time, last_rx_clock, hw, skb);
    }
}


inline void positioning_plugins_tx(struct ieee80211_hdr * hdr, struct ieee80211_sub_if_data *sdata)
{
    if (is_two_way_toa_enabled())	/* Gathering 2-way TOA data enabled? */
    {
	two_way_toa_timestamp_tx(hdr, sdata->wdev.wiphy);
    } 
}
inline void positioning_plugins_retx(struct ieee80211_hdr * hdr, struct ieee80211_local * local)
{
    /* Handling the transmissions previously enqueued */
    if (is_two_way_toa_enabled()) {	/* Gathering 2-way TOA data enabled? */ 
	two_way_toa_timestamp_tx(hdr, local->hw.wiphy); 
    }
}

