/*
 * Copyright 2013 Israel Martín Escalona <imartin@entel.upc.edu>
 * 
 * This file is part of Wipos.
 * 
 * Wipos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Wipos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Wipos.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef COMMON_PASSIVE_TDOA_H_
#define COMMON_PASSIVE_TDOA_H_

#include <linux/types.h>
#include <positioning/globals.h>

void common_passive_tdoa_init(void);
void common_passive_tdoa_exit(void);
void clear_buffer_common_passive_tdoa(void);
void set_gathering_buffer_common_passive_tdoa(unsigned long samples);
void enable_gathering_common_passive_tdoa(void);
void disable_gathering_common_passive_tdoa(void);
read_return_struct get_next_passive_tdoa_measurement(TYPE_OF_POSITIONING_DATA * buffer, unsigned long size);
unsigned long common_passive_tdoa_data_in_buffer(void);
void common_passive_tdoa_timestamp_rx_data(TYPE_OF_POSITIONING_DATA last_rx_time, TYPE_OF_POSITIONING_DATA last_rx_clock, struct sk_buff *skb);
void common_passive_tdoa_timestamp_rx_ack(TYPE_OF_POSITIONING_DATA last_rx_time, TYPE_OF_POSITIONING_DATA last_rx_clock, struct ieee80211_hw *hw, struct sk_buff *skb);
bool is_common_passive_tdoa_enabled(void);

void setActiveNodeAddressByStr(char * addr);
void setActiveNodeAddress(u8 * addr);
const u8 * getActiveNodeAddress(void);

#endif
